(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4804,        159]*)
(*NotebookOutlinePosition[      5447,        181]*)
(*  CellTagsIndexPosition[      5403,        177]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(Plot[{\(-Sqrt[1 - x^2]\), Sqrt[1 - x^2]}, {x, \(-1\), 1}, 
      AspectRatio \[Rule] Automatic, AxesLabel \[Rule] {"\<X\>", "\<Y\>"}, 
      PlotLabel -> "\<circunferencia\>", 
      Ticks \[Rule] {Table[i/10, {i, \(-10\), 10, 2}], {{1/4, "\<\>"}, 
            1/2, {3/4, "\<Si\>"}, 1}}, 
      Background \[Rule] RGBColor[1, 3/4, 1/2]]\)], "Input"],

Cell[BoxData[
    \(\(Composition[f, g, h, j]\)[x]\)], "Input"],

Cell[BoxData[
    \(\(\(\ \)\(\(iteracion[n_Integer]\)[f_] := 
      Apply[Composition, Table[f, {n}]]\)\)\)], "Input"],

Cell[BoxData[
    \(\(\(iteracion[3]\)[g]\)[x]\)], "Input"],

Cell[BoxData[
    \(Logisticmap[r_] := Function[x, r\ x \((1 - x)\)]\)], "Input"],

Cell[BoxData[
    \(super = {2, 3.2360, 3.4985, 3.5546, 3.5667, 3.5692}\)], "Input"],

Cell[BoxData[
    \(f[n_, 
        x_] := \(\(iteracion[2^\((n - 1)\)]\)[Logisticmap[super[\([n]\)]]]\)[
        x]\)], "Input"],

Cell[BoxData[
    \(f[4, x]\)], "Input"],

Cell[BoxData[
    \(Expand[%]\)], "Input"],

Cell[BoxData[
    \(f[6,  .33]\)], "Input"],

Cell[BoxData[
    \(Plot[f[1, x], {x, 0, 1}] // Timing\)], "Input"],

Cell[BoxData[
    \(p25 = Plot[f[6, x], {x, 0, 1}] // Timing\)], "Input"],

Cell[BoxData[
    \(p100 = 
      Plot[f[6, x], {x, 0, 1}, PlotPoints \[Rule] 100] // Timing\)], "Input"],

Cell[BoxData[
    \(Show[p25[\([2]\)], PlotRange \[Rule] { .35,  .56}]\)], "Input"],

Cell[BoxData[
    \(Show[p100[\([2]\)], PlotRange \[Rule] { .35,  .56}]\)], "Input"],

Cell[BoxData[
    \(p = 
      Table[Plot[f[n, x], {x, 0, 1}, PlotRange \[Rule] {0, 1}, 
          PlotStyle \[Rule] Hue[\((n - 1)\)/6]], {n, 6}]\)], "Input"],

Cell[BoxData[
    \(Show[%]\)], "Input"],

Cell[BoxData[
    \(\(plotlogfat = 
        ListPlot[Table[N[Log[\(i!\)]], {i, 100}], 
          PlotStyle \[Rule] {RGBColor[1, 0, 1], 
              PointSize[ .012]}];\)\)], "Input"],

Cell[BoxData[
    \(\(stir = 
        Plot[n\ Log[n] - n, {n, 1, 100}, PlotStyle \[Rule] RGBColor[0, 0, 1], 
          DisplayFunction \[Rule] Identity];\)\)], "Input"],

Cell[BoxData[
    \(Show[stir, plotlogfat, 
      DisplayFunction \[Rule] $DisplayFunction]\)], "Input"],

Cell[BoxData[
    \(ParametricPlot[{\((1 + Cos[t])\) Cos[t], \((1 + Cos[t])\) Sin[t]}, {t, 
        0, 2\ Pi}, AspectRatio \[Rule] Automatic]\)], "Input"],

Cell[BoxData[
    \(ParametricPlot[{Sin[t], Cos[2  t + 1]}, {t, 0, 2\ Pi}, 
      AspectRatio \[Rule] Automatic]\)], "Input"],

Cell[BoxData[
    \(ParametricPlot[{Sin[7  t], 3  Cos[10  t + 4]}, {t, 0, 2\ Pi}, 
      AspectRatio \[Rule] Automatic, 
      PlotRange \[Rule] {{\(-1.2\), 1.2}, {\(-3.2\), 3.2}}]\)], "Input"],

Cell[BoxData[
    \(ParametricPlot[{Sin[t], Sin[\(\@2\) t]}, {t, 0, 50}]\)], "Input"],

Cell[BoxData[
    \(ParametricPlot[{Sin[t], Sin[\(\@2\) t]}, {t, 0, 5000}]\)], "Input"],

Cell[BoxData[
    \(\(Plot[x^2, {x, 0, 1}];\)\)], "Input"],

Cell[BoxData[
    \(InputForm[%]\)], "Input"],

Cell[BoxData[
    \(ListPlot[Table[i^2, {i, 10}], 
      PlotStyle \[Rule] {PointSize[ .02], RGBColor[0, 1, 0]}]\)], "Input"],

Cell[BoxData[
    \(InputForm[%]\)], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 680}},
WindowSize->{940, 626},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 369, 6, 70, "Input"],
Cell[2077, 58, 63, 1, 30, "Input"],
Cell[2143, 61, 119, 2, 30, "Input"],
Cell[2265, 65, 59, 1, 30, "Input"],
Cell[2327, 68, 81, 1, 30, "Input"],
Cell[2411, 71, 84, 1, 30, "Input"],
Cell[2498, 74, 128, 3, 30, "Input"],
Cell[2629, 79, 40, 1, 30, "Input"],
Cell[2672, 82, 42, 1, 30, "Input"],
Cell[2717, 85, 43, 1, 30, "Input"],
Cell[2763, 88, 67, 1, 30, "Input"],
Cell[2833, 91, 73, 1, 30, "Input"],
Cell[2909, 94, 105, 2, 30, "Input"],
Cell[3017, 98, 83, 1, 30, "Input"],
Cell[3103, 101, 84, 1, 30, "Input"],
Cell[3190, 104, 158, 3, 30, "Input"],
Cell[3351, 109, 40, 1, 30, "Input"],
Cell[3394, 112, 184, 4, 30, "Input"],
Cell[3581, 118, 168, 3, 30, "Input"],
Cell[3752, 123, 104, 2, 30, "Input"],
Cell[3859, 127, 154, 2, 30, "Input"],
Cell[4016, 131, 125, 2, 30, "Input"],
Cell[4144, 135, 193, 3, 30, "Input"],
Cell[4340, 140, 85, 1, 33, "Input"],
Cell[4428, 143, 87, 1, 33, "Input"],
Cell[4518, 146, 58, 1, 30, "Input"],
Cell[4579, 149, 45, 1, 30, "Input"],
Cell[4627, 152, 125, 2, 30, "Input"],
Cell[4755, 156, 45, 1, 30, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

